package fr.asip.cps3.exemple.modele.resultats;

import java.util.Vector;

import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe reprsentant le rsultat d'un traitement
 */
public class Resultat {

	/**
	 * Objets potentiellement retourns par l'opration PKCS#11 
	 */
	protected Vector<Object> objets;
	
	/**
	 * Code retour PKCS#11 
	 */
	protected long codeRetour;

	/**
	 * Message retour 
	 */
	protected String retour;	
	
	/**
	 * Description du traitement  l'origine du rsultat
	 */
	protected String traitement;

	/**
	 * Constructeur
	 * @param traitement Description du traitement
	 */
	public Resultat(String traitement){
		this.codeRetour = 0L;
		this.retour = "";
		this.traitement = traitement;
		objets = new Vector<Object>();
	}

	/**
	 * Retourne le Code retour PKCS#11 sous forme de chane de caractres
	 * @return Code retour PKCS#11 sous forme de chane de caractres
	 */
	public String getCodeRetourStr() {
		return TraitementsUtil.retranscritCodeRetour(codeRetour);
	}
	
	/**
	 * Retourne le Code retour PKCS#11
	 * @return Code retour PKCS#11
	 */
	public long getCodeRetour() {
		return codeRetour;
	}

	/**
	 * Mutateur
	 * @param codeRetour Code retour PKCS#11
	 */
	public void setCodeRetour(long codeRetour) {
	   this.codeRetour = codeRetour;
	}

	/**
	 * Retourne le libell retour en cas de succs 
	 * @return Libell retour en cas de succs 
	 */
	public String getRetour() {
		return retour;
	}	
	
	/**
	 * Mutateur
	 * @param retour Libell retour en cas de succs
	 */
	public void setRetour(String retour) {
		this.retour = retour;
	}		
	
	/**
	 * Accesseur
	 * @return Traitement  l'origine du rsultat
	 */
	public String getTraitement() {
		return traitement;
	}

	/**
	 * Mutateur
	 * @param traitement Traitement  l'origine du rsultat
	 */
	public void setTraitement(String traitement) {
		this.traitement=traitement;
	}
		
	/**
	 * Ajoute du texte  la description de l'opration
	 * @param texte Texte  ajouter  la description de l'opration
	 */
	public void appendTraitement(String texte) {
		this.traitement += texte;
	}
	
	/**
	 * Accesseur
	 * @return Les objects potentiellement retourns par l'opration PKCS#11 
	 */
	public Vector<Object> getObjets() {
		return objets;
	}	
}
